// $Id: CMenu.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMenu.hpp"
#include "CSubMenuMenuItem.hpp"
using Exponent::GUI::Controls::CSubMenuMenuItem;
using Exponent::GUI::Controls::CMenu;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMenu, CCountedObject);

//	===========================================================================
CMenu::CMenu()
	 : m_subMenus(NULL)
	 , m_menuTitle("Menu Title")
{
	EXPONENT_CLASS_CONSTRUCTION(CMenu);
	m_subMenus = new TCountedPointerArray<CMenuItem>;
}

//	===========================================================================
CMenu::~CMenu()
{
	EXPONENT_CLASS_DESTRUCTION(CMenu);
	FREE_POINTER(m_subMenus);
}

//	===========================================================================
void CMenu::addMenuItem(CMenuItem *menuItem) 
{ 
	m_subMenus->addElement(menuItem); 
}

//	===========================================================================
CMenuItem *CMenu::getMenuItem(const long index) 
{ 
	return m_subMenus->elementAtIndex(index); 
}

//	===========================================================================
void CMenu::removeMenuItem(const long index) 
{ 
	m_subMenus->deletePointerAtIndex(index);
	m_subMenus->reorder(); 
}

//	===========================================================================
void CMenu::removeMenuItemNoOrdering(const long index)
{
	m_subMenus->deletePointerAtIndex(index);
}

//	===========================================================================
void CMenu::clearAllMenuItems()
{
	m_subMenus->clearArray();
}

//	===========================================================================
void CMenu::setMenuTitle(const CString &title) 
{ 
	m_menuTitle = title; 
}

//	===========================================================================
const CString &CMenu::getMenuTitle() const 
{ 
	return m_menuTitle; 
}

//	===========================================================================
long CMenu::getNumberOfMenuItems() const 
{ 
	return m_subMenus->getArraySize(); 
}

//	===========================================================================
void CMenu::getADivisionMenu(CMenu *addToThisMenu)
{
	// Create the sub menus
	CSubMenuMenuItem *straightMenu = new CSubMenuMenuItem("Straight", -1);
	CSubMenuMenuItem *tripletMenu  = new CSubMenuMenuItem("Triplet",  -1);
	CSubMenuMenuItem *dottedMenu   = new CSubMenuMenuItem("Dotted",   -1);

	// Add them to their menu
	addToThisMenu->addMenuItem(straightMenu);
	addToThisMenu->addMenuItem(tripletMenu);
	addToThisMenu->addMenuItem(dottedMenu);

	// Add to the straight menu
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("64",		0));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("32",		1));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("16",		2));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("8",		3));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("4",		4));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("2",		5));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1",		6));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/2",		7));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/4",		8));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/8",		9));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/16",	10));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/32",	11));
	straightMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/64",	12));

	// Add to the triplet menu
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("64T",		13));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("32T",		14));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("16T",		15));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("8T",		16));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("4T",		17));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("2T",		18));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1T",		19));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/2T",		20));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/4T",		21));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/8T",		22));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/16T",	23));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/32T",	24));
	tripletMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/64T",	25));

	// Add to the dotted menu
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("64D",		26));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("32D",		27));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("16D",		28));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("8D",		29));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("4D",		30));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("2D",		31));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1D",		32));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/2D",		33));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/4D",		34));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/8D",		35));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/16D",		36));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/32D",		37));
	dottedMenu->getMutableSubMenu()->addMenuItem(new CMenuItem("1/64D",		38));
}